/*
 * Decompiled with CFR 0.152.
 */
package net.hubalek.gradle.gitversion;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.hubalek.gradle.gitversion.GitVersionPlugin;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0016J\b\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u000b*\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000eH\u0002R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lnet/hubalek/gradle/gitversion/GitVersionPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "apply", "", "project", "gitCommand", "", "latestVersionName", "projectDir", "Ljava/io/File;", "runCommand", "workingDir", "git-version-plugin"})
public final class GitVersionPlugin
implements Plugin<Project> {
    private final Logger logger = LoggerFactory.getLogger((String)"GitVersionPlugin");

    /*
     * WARNING - void declaration
     */
    public void apply(@NotNull Project project) {
        void $this$mapTo$iv$iv;
        String string;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        File file = project.getRootDir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.rootDir");
        String string2 = string = this.latestVersionName(file);
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String gitVersionName = ((Object)StringsKt.trim((CharSequence)string2)).toString();
        this.logger.debug("Detected version `{}`", (Object)gitVersionName);
        String[] stringArray = new String[]{"."};
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)gitVersionName, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string3 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void v2 = it;
            if (v2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            collection.add(((Object)StringsKt.trim((CharSequence)((CharSequence)v2))).toString());
        }
        List parts = (List)destination$iv$iv;
        int major = Integer.parseInt((String)parts.get(0));
        int minor = Integer.parseInt((String)parts.get(1));
        int patch = Integer.parseInt((String)parts.get(2));
        boolean bl = 0 <= patch ? patch < 100 : (destination$iv$iv = false);
        if (_Assertions.ENABLED && !destination$iv$iv) {
            String $i$f$mapTo2 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)$i$f$mapTo2));
        }
        boolean bl2 = 0 <= minor ? minor < 100 : (destination$iv$iv = false);
        if (_Assertions.ENABLED && !destination$iv$iv) {
            String $i$f$mapTo2 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)$i$f$mapTo2));
        }
        int gitVersionCode = major * 10000 + minor * 100 + patch;
        String $i$f$mapTo2 = "Building version " + gitVersionName + " with versionCode " + gitVersionCode;
        System.out.println((Object)$i$f$mapTo2);
        Set set = project.getAllprojects();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"project.allprojects");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Project it = (Project)element$iv;
            boolean bl3 = false;
            it.getExtensions().getExtraProperties().set("gitVersionName", (Object)gitVersionName);
            it.getExtensions().getExtraProperties().set("gitVersionCode", (Object)gitVersionCode);
        }
    }

    private final String latestVersionName(File projectDir) {
        String string;
        String envTag = System.getenv().get("BUILD_VERSION");
        if (envTag != null && !Intrinsics.areEqual((Object)envTag, (Object)"")) {
            this.logger.debug("Using tag from environment variable: `{}`", (Object)envTag);
            string = envTag;
        } else {
            String command = this.gitCommand() + " describe --abbrev=0 --tags";
            File workingDir = projectDir.getAbsoluteFile();
            this.logger.debug("Command is `{}`, working dir is `{}`", (Object)command, (Object)workingDir.getAbsolutePath());
            Intrinsics.checkNotNullExpressionValue((Object)workingDir, (String)"workingDir");
            string = this.runCommand(command, workingDir);
            if (string == null) {
                throw new UnsupportedOperationException("Unable to invoke GIT");
            }
        }
        return string;
    }

    private final String gitCommand() {
        Object[] objectArray = new String[]{"/usr/bin/git", "/usr/local/bin/git"};
        List possibleGitLocations = CollectionsKt.listOf((Object[])objectArray);
        Iterable $this$forEach$iv = possibleGitLocations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String gitBinFilePath = (String)element$iv;
            boolean bl = false;
            if (!new File(gitBinFilePath).exists()) continue;
            this.logger.debug("Returning git bin {}", (Object)gitBinFilePath);
            return gitBinFilePath;
        }
        throw new UnsupportedOperationException("Unable to find git command");
    }

    private final String runCommand(String $this$runCommand, File workingDir) {
        CharSequence charSequence = $this$runCommand;
        String[] stringArray = new Regex("\\s");
        int n = 0;
        List parts = stringArray.split(charSequence, n);
        try {
            Collection $this$toTypedArray$iv = parts;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
            if (stringArray2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            stringArray = stringArray2;
            Process process = new ProcessBuilder(Arrays.copyOf(stringArray, stringArray.length)).directory(workingDir).redirectErrorStream(true).redirectOutput(ProcessBuilder.Redirect.PIPE).redirectError(ProcessBuilder.Redirect.PIPE).start();
            process.waitFor(60L, TimeUnit.MINUTES);
            InputStream inputStream = process.getInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"process.inputStream");
            InputStream inputStream2 = inputStream;
            Charset charset = Charsets.UTF_8;
            Closeable closeable = inputStream2;
            closeable = new InputStreamReader((InputStream)closeable, charset);
            int n2 = 8192;
            String result = TextStreamsKt.readText((Reader)(closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n2)));
            this.logger.info("Process returned `" + result + "`, for " + CollectionsKt.joinToString$default((Iterable)parts, null, null, null, (int)0, null, (Function1)runCommand.1.INSTANCE, (int)31, null));
            charSequence = result;
        }
        catch (IOException e) {
            this.logger.error("Error while executing " + CollectionsKt.joinToString$default((Iterable)parts, null, null, null, (int)0, null, (Function1)runCommand.2.INSTANCE, (int)31, null), (Throwable)e);
            e.printStackTrace();
            charSequence = null;
        }
        return charSequence;
    }
}

