/*
 * Decompiled with CFR 0.152.
 */
package net.hubalek.gradle.gitreleasenotes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.hubalek.gradle.gitreleasenotes.ReleaseNotesGeneratorKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0005\u001f !\"#B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0002J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\u0004H\u0002J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\r\u001a\u00020\u0004H\u0002J\u001c\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0004H\u0002J\u0010\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0004H\u0002J\u0016\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u001e\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0004J@\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\t2\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u00042\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lnet/hubalek/gradle/gitreleasenotes/ReleaseNotesGenerator;", "", "()V", "COMMENTS_DELIMITER", "", "debugLog", "", "msg", "extractCommentsList", "", "Lnet/hubalek/gradle/gitreleasenotes/ReleaseNotesGenerator$CommentInfo;", "commentsLog", "extractTag", "rawTagInfo", "extractTagsMap", "", "Lnet/hubalek/gradle/gitreleasenotes/ReleaseNotesGenerator$TagInfo;", "tagsLog", "extractVersionPrefix", "currentVersion", "formatReleaseNotes", "data", "Lnet/hubalek/gradle/gitreleasenotes/ReleaseNotesGenerator$VersionNotes;", "maxLength", "", "generateReleaseNotes", "mergeTagsAndComments", "Lnet/hubalek/gradle/gitreleasenotes/ReleaseNotesGenerator$VersionNote;", "versionPrefix", "tags", "comments", "CommentInfo", "NoteType", "TagInfo", "VersionNote", "VersionNotes", "plugin"})
@SourceDebugExtension(value={"SMAP\nReleaseNotesGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReleaseNotesGenerator.kt\nnet/hubalek/gradle/gitreleasenotes/ReleaseNotesGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,185:1\n1603#2,9:186\n1855#2:195\n1856#2:197\n1612#2:198\n1603#2,9:199\n1855#2:208\n1856#2:210\n1612#2:211\n1603#2,9:212\n1855#2:221\n1856#2:223\n1612#2:224\n1549#2:225\n1620#2,3:226\n1855#2,2:229\n1#3:196\n1#3:209\n1#3:222\n*S KotlinDebug\n*F\n+ 1 ReleaseNotesGenerator.kt\nnet/hubalek/gradle/gitreleasenotes/ReleaseNotesGenerator\n*L\n46#1:186,9\n46#1:195\n46#1:197\n46#1:198\n94#1:199,9\n94#1:208\n94#1:210\n94#1:211\n108#1:212,9\n108#1:221\n108#1:223\n108#1:224\n123#1:225\n123#1:226,3\n133#1:229,2\n46#1:196\n94#1:209\n108#1:222\n*E\n"})
public final class ReleaseNotesGenerator {
    @NotNull
    public static final ReleaseNotesGenerator INSTANCE = new ReleaseNotesGenerator();
    @NotNull
    public static final String COMMENTS_DELIMITER = ":";

    private ReleaseNotesGenerator() {
    }

    @NotNull
    public final VersionNotes generateReleaseNotes(@NotNull String currentVersion, @NotNull String tagsLog2, @NotNull String commentsLog2) {
        Intrinsics.checkNotNullParameter((Object)currentVersion, (String)"currentVersion");
        Intrinsics.checkNotNullParameter((Object)tagsLog2, (String)"tagsLog");
        Intrinsics.checkNotNullParameter((Object)commentsLog2, (String)"commentsLog");
        this.debugLog("Comments log: " + commentsLog2);
        this.debugLog("Tags log: " + tagsLog2);
        String versionPrefix = this.extractVersionPrefix(currentVersion);
        Map<String, TagInfo> tags = this.extractTagsMap(tagsLog2);
        List<CommentInfo> comments = this.extractCommentsList(commentsLog2);
        this.debugLog("List of comments and tags: ");
        this.debugLog("--------------------------");
        List<VersionNote> versionNotes = this.mergeTagsAndComments(currentVersion, versionPrefix, tags, comments);
        this.debugLog("--------------------------");
        return new VersionNotes(versionPrefix + 'x', CollectionsKt.reversed((Iterable)versionNotes));
    }

    private final void debugLog(String msg) {
        Logger.getLogger(ReleaseNotesGenerator.class.getSimpleName()).log(Level.FINE, msg);
    }

    private final String extractVersionPrefix(String currentVersion) {
        String string = currentVersion.substring(0, StringsKt.lastIndexOf$default((CharSequence)currentVersion, (String)".", (int)0, (boolean)false, (int)6, null) + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return string;
    }

    /*
     * Unable to fully structure code
     */
    private final List<VersionNote> mergeTagsAndComments(String currentVersion, String versionPrefix, Map<String, TagInfo> tags, List<CommentInfo> comments) {
        latestTagInfo = null;
        $this$mapNotNull$iv = comments;
        $i$f$mapNotNull = false;
        var8_8 = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        $i$f$forEach = false;
        var13_13 = $this$forEach$iv$iv$iv.iterator();
        while (var13_13.hasNext()) {
            block5: {
                block10: {
                    block9: {
                        block7: {
                            block8: {
                                block6: {
                                    block4: {
                                        element$iv$iv = element$iv$iv$iv = var13_13.next();
                                        $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                                        it = (CommentInfo)element$iv$iv;
                                        $i$a$-mapNotNull-ReleaseNotesGenerator$mergeTagsAndComments$1 = false;
                                        v0 = latestTagInfo;
                                        latestTag = v0 != null ? v0.getTag() : null;
                                        currentTagInfo = tags.get(it.getCommitHash());
                                        if (currentTagInfo != null) {
                                            latestTagInfo = currentTagInfo;
                                        }
                                        comment = ReleaseNotesGeneratorKt.stripJIRATags(it.getComment());
                                        ReleaseNotesGenerator.INSTANCE.debugLog('[' + it.getCommitHash() + "]:[" + latestTag + "] -  " + comment);
                                        if (StringsKt.startsWith$default((String)comment, (String)"[", (boolean)false, (int)2, null)) break block4;
                                        v1 = null;
                                        break block5;
                                    }
                                    if (!StringsKt.startsWith$default((String)comment, (String)"[FEATURE]", (boolean)false, (int)2, null)) break block6;
                                    v2 = NoteType.FEATURE;
                                    break block7;
                                }
                                if (StringsKt.startsWith$default((String)comment, (String)"[BUGFIX]", (boolean)false, (int)2, null)) break block8;
                                v1 = null;
                                break block5;
                            }
                            v2 = NoteType.BUGFIX;
                        }
                        noteType = v2;
                        v3 = comment.substring(StringsKt.indexOf$default((CharSequence)comment, (String)"]", (int)0, (boolean)false, (int)6, null) + 1);
                        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"substring(...)");
                        commentText = StringsKt.trim((CharSequence)v3).toString();
                        if (!(((CharSequence)commentText).length() == 0)) break block9;
                        v1 = null;
                        break block5;
                    }
                    if (latestTag == null || !StringsKt.startsWith$default((String)latestTag, (String)versionPrefix, (boolean)false, (int)2, null)) break block10;
                    v4 = latestTag;
                    ** GOTO lbl53
                }
                if (latestTag != null) {
                    v1 = null;
                } else {
                    v4 = currentVersion;
lbl53:
                    // 2 sources

                    version = v4;
                    v1 = new VersionNote(version, noteType, commentText);
                }
            }
            if (v1 == null) continue;
            it$iv$iv = v1;
            $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.reversed((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private final List<CommentInfo> extractCommentsList(String commentsLog2) {
        void $this$mapNotNullTo$iv$iv;
        String[] stringArray = new String[]{"\n"};
        Iterable $this$mapNotNull$iv = StringsKt.split$default((CharSequence)commentsLog2, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            CommentInfo commentInfo;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String singleComment = (String)element$iv$iv;
            boolean bl2 = false;
            int indexOfDelimiter = StringsKt.indexOf$default((CharSequence)singleComment, (String)COMMENTS_DELIMITER, (int)0, (boolean)false, (int)6, null);
            if (indexOfDelimiter >= 0) {
                String string = singleComment.substring(0, indexOfDelimiter);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                String string2 = singleComment.substring(indexOfDelimiter + 1, singleComment.length());
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                commentInfo = new CommentInfo(string, string2);
            } else {
                commentInfo = null;
            }
            if (commentInfo == null) continue;
            CommentInfo it$iv$iv = commentInfo;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, TagInfo> extractTagsMap(String tagsLog2) {
        void $this$mapTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        String[] stringArray = new String[]{"\n"};
        Iterable $this$mapNotNull$iv = StringsKt.split$default((CharSequence)tagsLog2, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Object object = $this$forEach$iv$iv$iv.iterator();
        while (object.hasNext()) {
            TagInfo tagInfo;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = object.next();
            boolean bl = false;
            String singleTagLog = (String)element$iv$iv;
            boolean bl2 = false;
            int indexOfDelimiter = StringsKt.indexOf$default((CharSequence)singleTagLog, (String)COMMENTS_DELIMITER, (int)0, (boolean)false, (int)6, null);
            if (indexOfDelimiter >= 0) {
                String string = singleTagLog.substring(indexOfDelimiter + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                String rawTagInfo = INSTANCE.extractTag(string);
                if (rawTagInfo != null) {
                    String commitHash;
                    Intrinsics.checkNotNullExpressionValue((Object)singleTagLog.substring(0, indexOfDelimiter), (String)"substring(...)");
                    tagInfo = new TagInfo(commitHash, rawTagInfo);
                } else {
                    tagInfo = null;
                }
            } else {
                tagInfo = null;
            }
            if (tagInfo == null) continue;
            TagInfo it$iv$iv = tagInfo;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$mapNotNullTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            object = (TagInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)it.getCommitHash(), (Object)it));
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    @NotNull
    public final String formatReleaseNotes(@NotNull VersionNotes data, int maxLength) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        String header = "Release notes for version " + data.getVersion() + "\n--------------------------------";
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(header);
        Set alreadyReportedComments = new LinkedHashSet();
        Iterable $this$forEach$iv = data.getNotes();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VersionNote note = (VersionNote)element$iv;
            boolean bl = false;
            String noteText = "\n- " + note.getText() + " (version " + note.getVersion() + ')';
            if (stringBuilder.length() + noteText.length() >= maxLength || alreadyReportedComments.contains(note.getText())) continue;
            stringBuilder.append(noteText);
            ((Collection)alreadyReportedComments).add(note.getText());
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final String extractTag(String rawTagInfo) {
        String string;
        Regex regex = new Regex("refs/tags/([0-9]+)\\.([0-9]+)\\.([0-9]+)");
        MatchResult split = Regex.find$default((Regex)regex, (CharSequence)rawTagInfo, (int)0, (int)2, null);
        if (split != null) {
            List groups = split.getGroupValues();
            string = (String)groups.get(1) + '.' + (String)groups.get(2) + '.' + (String)groups.get(3);
        } else {
            string = null;
        }
        return string;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lnet/hubalek/gradle/gitreleasenotes/ReleaseNotesGenerator$CommentInfo;", "", "commitHash", "", "comment", "(Ljava/lang/String;Ljava/lang/String;)V", "getComment", "()Ljava/lang/String;", "getCommitHash", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "plugin"})
    private static final class CommentInfo {
        @NotNull
        private final String commitHash;
        @NotNull
        private final String comment;

        public CommentInfo(@NotNull String commitHash, @NotNull String comment) {
            Intrinsics.checkNotNullParameter((Object)commitHash, (String)"commitHash");
            Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
            this.commitHash = commitHash;
            this.comment = comment;
        }

        @NotNull
        public final String getCommitHash() {
            return this.commitHash;
        }

        @NotNull
        public final String getComment() {
            return this.comment;
        }

        @NotNull
        public final String component1() {
            return this.commitHash;
        }

        @NotNull
        public final String component2() {
            return this.comment;
        }

        @NotNull
        public final CommentInfo copy(@NotNull String commitHash, @NotNull String comment) {
            Intrinsics.checkNotNullParameter((Object)commitHash, (String)"commitHash");
            Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
            return new CommentInfo(commitHash, comment);
        }

        public static /* synthetic */ CommentInfo copy$default(CommentInfo commentInfo, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = commentInfo.commitHash;
            }
            if ((n & 2) != 0) {
                string2 = commentInfo.comment;
            }
            return commentInfo.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "CommentInfo(commitHash=" + this.commitHash + ", comment=" + this.comment + ')';
        }

        public int hashCode() {
            int result = this.commitHash.hashCode();
            result = result * 31 + this.comment.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CommentInfo)) {
                return false;
            }
            CommentInfo commentInfo = (CommentInfo)other;
            if (!Intrinsics.areEqual((Object)this.commitHash, (Object)commentInfo.commitHash)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.comment, (Object)commentInfo.comment);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lnet/hubalek/gradle/gitreleasenotes/ReleaseNotesGenerator$NoteType;", "", "(Ljava/lang/String;I)V", "FEATURE", "BUGFIX", "plugin"})
    public static final class NoteType
    extends Enum<NoteType> {
        public static final /* enum */ NoteType FEATURE = new NoteType();
        public static final /* enum */ NoteType BUGFIX = new NoteType();
        private static final /* synthetic */ NoteType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NoteType[] values() {
            return (NoteType[])$VALUES.clone();
        }

        public static NoteType valueOf(String value) {
            return Enum.valueOf(NoteType.class, value);
        }

        @NotNull
        public static EnumEntries<NoteType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = noteTypeArray = new NoteType[]{NoteType.FEATURE, NoteType.BUGFIX};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lnet/hubalek/gradle/gitreleasenotes/ReleaseNotesGenerator$TagInfo;", "", "commitHash", "", "tag", "(Ljava/lang/String;Ljava/lang/String;)V", "getCommitHash", "()Ljava/lang/String;", "getTag", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "plugin"})
    private static final class TagInfo {
        @NotNull
        private final String commitHash;
        @NotNull
        private final String tag;

        public TagInfo(@NotNull String commitHash, @NotNull String tag) {
            Intrinsics.checkNotNullParameter((Object)commitHash, (String)"commitHash");
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            this.commitHash = commitHash;
            this.tag = tag;
        }

        @NotNull
        public final String getCommitHash() {
            return this.commitHash;
        }

        @NotNull
        public final String getTag() {
            return this.tag;
        }

        @NotNull
        public final String component1() {
            return this.commitHash;
        }

        @NotNull
        public final String component2() {
            return this.tag;
        }

        @NotNull
        public final TagInfo copy(@NotNull String commitHash, @NotNull String tag) {
            Intrinsics.checkNotNullParameter((Object)commitHash, (String)"commitHash");
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            return new TagInfo(commitHash, tag);
        }

        public static /* synthetic */ TagInfo copy$default(TagInfo tagInfo, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = tagInfo.commitHash;
            }
            if ((n & 2) != 0) {
                string2 = tagInfo.tag;
            }
            return tagInfo.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "TagInfo(commitHash=" + this.commitHash + ", tag=" + this.tag + ')';
        }

        public int hashCode() {
            int result = this.commitHash.hashCode();
            result = result * 31 + this.tag.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TagInfo)) {
                return false;
            }
            TagInfo tagInfo = (TagInfo)other;
            if (!Intrinsics.areEqual((Object)this.commitHash, (Object)tagInfo.commitHash)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.tag, (Object)tagInfo.tag);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lnet/hubalek/gradle/gitreleasenotes/ReleaseNotesGenerator$VersionNote;", "", "version", "", "noteType", "Lnet/hubalek/gradle/gitreleasenotes/ReleaseNotesGenerator$NoteType;", "text", "(Ljava/lang/String;Lnet/hubalek/gradle/gitreleasenotes/ReleaseNotesGenerator$NoteType;Ljava/lang/String;)V", "getNoteType", "()Lnet/hubalek/gradle/gitreleasenotes/ReleaseNotesGenerator$NoteType;", "getText", "()Ljava/lang/String;", "getVersion", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "plugin"})
    public static final class VersionNote {
        @NotNull
        private final String version;
        @NotNull
        private final NoteType noteType;
        @NotNull
        private final String text;

        public VersionNote(@NotNull String version, @NotNull NoteType noteType, @NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            Intrinsics.checkNotNullParameter((Object)((Object)noteType), (String)"noteType");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            this.version = version;
            this.noteType = noteType;
            this.text = text;
        }

        @NotNull
        public final String getVersion() {
            return this.version;
        }

        @NotNull
        public final NoteType getNoteType() {
            return this.noteType;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        @NotNull
        public final String component1() {
            return this.version;
        }

        @NotNull
        public final NoteType component2() {
            return this.noteType;
        }

        @NotNull
        public final String component3() {
            return this.text;
        }

        @NotNull
        public final VersionNote copy(@NotNull String version, @NotNull NoteType noteType, @NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            Intrinsics.checkNotNullParameter((Object)((Object)noteType), (String)"noteType");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            return new VersionNote(version, noteType, text);
        }

        public static /* synthetic */ VersionNote copy$default(VersionNote versionNote, String string, NoteType noteType, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = versionNote.version;
            }
            if ((n & 2) != 0) {
                noteType = versionNote.noteType;
            }
            if ((n & 4) != 0) {
                string2 = versionNote.text;
            }
            return versionNote.copy(string, noteType, string2);
        }

        @NotNull
        public String toString() {
            return "VersionNote(version=" + this.version + ", noteType=" + (Object)((Object)this.noteType) + ", text=" + this.text + ')';
        }

        public int hashCode() {
            int result = this.version.hashCode();
            result = result * 31 + this.noteType.hashCode();
            result = result * 31 + this.text.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof VersionNote)) {
                return false;
            }
            VersionNote versionNote = (VersionNote)other;
            if (!Intrinsics.areEqual((Object)this.version, (Object)versionNote.version)) {
                return false;
            }
            if (this.noteType != versionNote.noteType) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.text, (Object)versionNote.text);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lnet/hubalek/gradle/gitreleasenotes/ReleaseNotesGenerator$VersionNotes;", "", "version", "", "notes", "", "Lnet/hubalek/gradle/gitreleasenotes/ReleaseNotesGenerator$VersionNote;", "(Ljava/lang/String;Ljava/util/List;)V", "getNotes", "()Ljava/util/List;", "getVersion", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "plugin"})
    public static final class VersionNotes {
        @NotNull
        private final String version;
        @NotNull
        private final List<VersionNote> notes;

        public VersionNotes(@NotNull String version, @NotNull List<VersionNote> notes) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            Intrinsics.checkNotNullParameter(notes, (String)"notes");
            this.version = version;
            this.notes = notes;
        }

        @NotNull
        public final String getVersion() {
            return this.version;
        }

        @NotNull
        public final List<VersionNote> getNotes() {
            return this.notes;
        }

        @NotNull
        public final String component1() {
            return this.version;
        }

        @NotNull
        public final List<VersionNote> component2() {
            return this.notes;
        }

        @NotNull
        public final VersionNotes copy(@NotNull String version, @NotNull List<VersionNote> notes) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            Intrinsics.checkNotNullParameter(notes, (String)"notes");
            return new VersionNotes(version, notes);
        }

        public static /* synthetic */ VersionNotes copy$default(VersionNotes versionNotes, String string, List list, int n, Object object) {
            if ((n & 1) != 0) {
                string = versionNotes.version;
            }
            if ((n & 2) != 0) {
                list = versionNotes.notes;
            }
            return versionNotes.copy(string, list);
        }

        @NotNull
        public String toString() {
            return "VersionNotes(version=" + this.version + ", notes=" + this.notes + ')';
        }

        public int hashCode() {
            int result = this.version.hashCode();
            result = result * 31 + ((Object)this.notes).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof VersionNotes)) {
                return false;
            }
            VersionNotes versionNotes = (VersionNotes)other;
            if (!Intrinsics.areEqual((Object)this.version, (Object)versionNotes.version)) {
                return false;
            }
            return Intrinsics.areEqual(this.notes, versionNotes.notes);
        }
    }
}

