/*
 * Decompiled with CFR 0.152.
 */
package net.hubalek.gradle.gitreleasenotes;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.hubalek.gradle.gitreleasenotes.GitExecutionValueSourceParameters;
import org.gradle.api.provider.ValueSource;
import org.gradle.process.ExecOperations;
import org.gradle.process.ExecSpec;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\b&\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0002H\u0004J\u0010\u0010\u0011\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\u0012\u001a\u00020\u0002H\u0016R\u000e\u0010\u0004\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0013"}, d2={"Lnet/hubalek/gradle/gitreleasenotes/GitValueSource;", "Lorg/gradle/api/provider/ValueSource;", "", "Lnet/hubalek/gradle/gitreleasenotes/GitExecutionValueSourceParameters;", "command", "(Ljava/lang/String;)V", "execOperations", "Lorg/gradle/process/ExecOperations;", "getExecOperations", "()Lorg/gradle/process/ExecOperations;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLogger", "()Lorg/slf4j/Logger;", "callGit", "gitArgs", "gitCommand", "obtain", "plugin"})
@SourceDebugExtension(value={"SMAP\nGenerateReleaseNotesTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GenerateReleaseNotesTask.kt\nnet/hubalek/gradle/gitreleasenotes/GitValueSource\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,168:1\n1855#2,2:169\n*S KotlinDebug\n*F\n+ 1 GenerateReleaseNotesTask.kt\nnet/hubalek/gradle/gitreleasenotes/GitValueSource\n*L\n125#1:169,2\n*E\n"})
public abstract class GitValueSource
implements ValueSource<String, GitExecutionValueSourceParameters> {
    @NotNull
    private final String command;
    private final Logger logger;

    public GitValueSource(@NotNull String command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        this.command = command;
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    protected final Logger getLogger() {
        return this.logger;
    }

    @Inject
    @NotNull
    public abstract ExecOperations getExecOperations();

    @NotNull
    public String obtain() {
        Logger logger = this.logger;
        Intrinsics.checkNotNull((Object)logger);
        String gitCommand = this.gitCommand(logger);
        String result2 = this.callGit(this.command);
        return result2;
    }

    @NotNull
    protected final String callGit(@NotNull String gitArgs) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)gitArgs, (String)"gitArgs");
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        File workingDir = new File((String)((GitExecutionValueSourceParameters)this.getParameters()).getWorkingDir().get());
        Object[] objectArray = new Object[]{workingDir, gitArgs, this.command};
        this.logger.debug("Using working dir {} and command {} {}", objectArray);
        this.logger.debug("Working dir exists: " + workingDir.exists());
        try {
            this.getExecOperations().exec(arg_0 -> GitValueSource.callGit$lambda$0((Function1)new Function1<ExecSpec, Unit>(workingDir, output, this, gitArgs){
                final /* synthetic */ File $workingDir;
                final /* synthetic */ ByteArrayOutputStream $output;
                final /* synthetic */ GitValueSource this$0;
                final /* synthetic */ String $gitArgs;
                {
                    this.$workingDir = $workingDir;
                    this.$output = $output;
                    this.this$0 = $receiver;
                    this.$gitArgs = $gitArgs;
                    super(1);
                }

                public final void invoke(ExecSpec it) {
                    it.setWorkingDir(this.$workingDir);
                    it.setStandardOutput((OutputStream)this.$output);
                    SpreadBuilder spreadBuilder = new SpreadBuilder(2);
                    Logger logger = this.this$0.getLogger();
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"<get-logger>(...)");
                    spreadBuilder.add((Object)GitValueSource.access$gitCommand(this.this$0, logger));
                    CharSequence charSequence = this.$gitArgs;
                    Regex regex = new Regex("\\s+");
                    int n = 0;
                    Collection $this$toTypedArray$iv = regex.split(charSequence, n);
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    spreadBuilder.addSpread((Object)thisCollection$iv.toArray(new String[0]));
                    it.commandLine(spreadBuilder.toArray(new Object[spreadBuilder.size()]));
                }
            }, arg_0));
            byte[] byArray = output.toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
            object = byArray;
            Charset charset = Charset.defaultCharset();
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"defaultCharset(...)");
            Charset charset2 = charset;
            object = ((Object)StringsKt.trim((CharSequence)new String((byte[])object, charset2))).toString();
        }
        catch (Throwable e) {
            this.logger.error("Error executing git", e);
            throw e;
        }
        Object result2 = object;
        return result2;
    }

    private final String gitCommand(Logger logger) {
        Object[] objectArray = new String[]{"/usr/bin/git", "/usr/local/bin/git"};
        List possibleGitLocations = CollectionsKt.listOf((Object[])objectArray);
        Iterable $this$forEach$iv = possibleGitLocations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String gitBinFilePath = (String)element$iv;
            boolean bl = false;
            if (!new File(gitBinFilePath).exists()) continue;
            logger.debug("Returning git bin " + gitBinFilePath);
            return gitBinFilePath;
        }
        throw new UnsupportedOperationException("Unable to find git command");
    }

    private static final void callGit$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ String access$gitCommand(GitValueSource $this, Logger logger) {
        return $this.gitCommand(logger);
    }
}

