/*
 * Decompiled with CFR 0.152.
 */
package net.hubalek.gradle.gitreleasenotes;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.hubalek.gradle.gitreleasenotes.CommentsValueSource;
import net.hubalek.gradle.gitreleasenotes.GenerateReleaseNotesTask;
import net.hubalek.gradle.gitreleasenotes.GitExecutionValueSourceParameters;
import net.hubalek.gradle.gitreleasenotes.LatestVersionNameValueSource;
import net.hubalek.gradle.gitreleasenotes.ReleaseNotesGenerator;
import net.hubalek.gradle.gitreleasenotes.TagsValueSource;
import org.gradle.api.DefaultTask;
import org.gradle.api.logging.Logger;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.provider.ValueSourceSpec;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0012\u001a\u00020\u0013H\u0007R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\t\u00a8\u0006\u0014"}, d2={"Lnet/hubalek/gradle/gitreleasenotes/GenerateReleaseNotesTask;", "Lorg/gradle/api/DefaultTask;", "providers", "Lorg/gradle/api/provider/ProviderFactory;", "(Lorg/gradle/api/provider/ProviderFactory;)V", "maxTextLength", "Lorg/gradle/api/provider/Property;", "", "getMaxTextLength", "()Lorg/gradle/api/provider/Property;", "targetFiles", "Lorg/gradle/api/provider/ListProperty;", "", "getTargetFiles", "()Lorg/gradle/api/provider/ListProperty;", "workingDir", "", "getWorkingDir", "taskAction", "", "plugin"})
@SourceDebugExtension(value={"SMAP\nGenerateReleaseNotesTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GenerateReleaseNotesTask.kt\nnet/hubalek/gradle/gitreleasenotes/GenerateReleaseNotesTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,168:1\n1549#2:169\n1620#2,3:170\n1855#2,2:173\n*S KotlinDebug\n*F\n+ 1 GenerateReleaseNotesTask.kt\nnet/hubalek/gradle/gitreleasenotes/GenerateReleaseNotesTask\n*L\n47#1:169\n47#1:170,3\n82#1:173,2\n*E\n"})
public abstract class GenerateReleaseNotesTask
extends DefaultTask {
    @NotNull
    private final ProviderFactory providers;

    @Inject
    public GenerateReleaseNotesTask(@NotNull ProviderFactory providers) {
        Intrinsics.checkNotNullParameter((Object)providers, (String)"providers");
        this.providers = providers;
    }

    @Input
    @NotNull
    public abstract ListProperty<CharSequence> getTargetFiles();

    @Input
    @NotNull
    public abstract Property<Integer> getMaxTextLength();

    @Input
    @NotNull
    public abstract Property<String> getWorkingDir();

    /*
     * WARNING - void declaration
     */
    @TaskAction
    public final void taskAction() {
        void $this$mapTo$iv$iv;
        String workingDir = (String)this.getWorkingDir().get();
        this.getLogger().debug("workingDir=" + workingDir);
        String gitVersionName2 = (String)this.providers.of(LatestVersionNameValueSource.class, arg_0 -> GenerateReleaseNotesTask.taskAction$lambda$0((Function1)new Function1<ValueSourceSpec<GitExecutionValueSourceParameters>, Unit>(workingDir){
            final /* synthetic */ String $workingDir;
            {
                this.$workingDir = $workingDir;
                super(1);
            }

            public final void invoke(@NotNull ValueSourceSpec<GitExecutionValueSourceParameters> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                it.parameters(arg_0 -> taskAction.gitVersionName.1.invoke$lambda$0((Function1)new Function1<GitExecutionValueSourceParameters, Unit>(this.$workingDir){
                    final /* synthetic */ String $workingDir;
                    {
                        this.$workingDir = $workingDir;
                        super(1);
                    }

                    public final void invoke(GitExecutionValueSourceParameters it) {
                        it.getWorkingDir().set((Object)this.$workingDir);
                    }
                }, arg_0));
            }

            private static final void invoke$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke(p0);
            }
        }, arg_0)).get();
        this.getLogger().info("\nCreating release notes for version `" + gitVersionName2 + '`');
        Logger logger = this.getLogger();
        StringBuilder stringBuilder = new StringBuilder().append("Storing to following files:\n");
        Object object = this.getTargetFiles().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        logger.info(stringBuilder.append(CollectionsKt.joinToString$default((Iterable)((Iterable)object), (CharSequence)"\n", null, null, (int)0, null, (Function1)taskAction.1.INSTANCE, (int)30, null)).append('\n').toString());
        Intrinsics.checkNotNull((Object)gitVersionName2);
        String[] stringArray = new String[]{"."};
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)gitVersionName2, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Object)StringsKt.trim((CharSequence)((CharSequence)it))).toString());
        }
        List parts = (List)destination$iv$iv;
        int major = Integer.parseInt((String)parts.get(0));
        int minor = Integer.parseInt((String)parts.get(1));
        int patch = Integer.parseInt((String)parts.get(2));
        boolean bl = 0 <= patch ? patch < 100 : (destination$iv$iv = false);
        if (_Assertions.ENABLED && !destination$iv$iv) {
            String $i$f$mapTo2 = "Assertion failed";
            throw new AssertionError((Object)$i$f$mapTo2);
        }
        boolean bl2 = 0 <= minor ? minor < 100 : (destination$iv$iv = false);
        if (_Assertions.ENABLED && !destination$iv$iv) {
            String $i$f$mapTo2 = "Assertion failed";
            throw new AssertionError((Object)$i$f$mapTo2);
        }
        String tagsLog2 = (String)this.providers.of(TagsValueSource.class, arg_0 -> GenerateReleaseNotesTask.taskAction$lambda$2((Function1)new Function1<ValueSourceSpec<GitExecutionValueSourceParameters>, Unit>(workingDir){
            final /* synthetic */ String $workingDir;
            {
                this.$workingDir = $workingDir;
                super(1);
            }

            public final void invoke(@NotNull ValueSourceSpec<GitExecutionValueSourceParameters> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                it.parameters(arg_0 -> taskAction.tagsLog.1.invoke$lambda$0((Function1)new Function1<GitExecutionValueSourceParameters, Unit>(this.$workingDir){
                    final /* synthetic */ String $workingDir;
                    {
                        this.$workingDir = $workingDir;
                        super(1);
                    }

                    public final void invoke(GitExecutionValueSourceParameters it) {
                        it.getWorkingDir().set((Object)this.$workingDir);
                    }
                }, arg_0));
            }

            private static final void invoke$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke(p0);
            }
        }, arg_0)).get();
        String commentsLog2 = (String)this.providers.of(CommentsValueSource.class, arg_0 -> GenerateReleaseNotesTask.taskAction$lambda$3((Function1)new Function1<ValueSourceSpec<GitExecutionValueSourceParameters>, Unit>(workingDir){
            final /* synthetic */ String $workingDir;
            {
                this.$workingDir = $workingDir;
                super(1);
            }

            public final void invoke(@NotNull ValueSourceSpec<GitExecutionValueSourceParameters> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                it.parameters(arg_0 -> taskAction.commentsLog.1.invoke$lambda$0((Function1)new Function1<GitExecutionValueSourceParameters, Unit>(this.$workingDir){
                    final /* synthetic */ String $workingDir;
                    {
                        this.$workingDir = $workingDir;
                        super(1);
                    }

                    public final void invoke(GitExecutionValueSourceParameters it) {
                        it.getWorkingDir().set((Object)this.$workingDir);
                    }
                }, arg_0));
            }

            private static final void invoke$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke(p0);
            }
        }, arg_0)).get();
        Intrinsics.checkNotNull((Object)tagsLog2);
        Intrinsics.checkNotNull((Object)commentsLog2);
        ReleaseNotesGenerator.VersionNotes versionNotes = ReleaseNotesGenerator.INSTANCE.generateReleaseNotes(gitVersionName2, tagsLog2, commentsLog2);
        Object object2 = this.getMaxTextLength().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        String releaseNotes = ReleaseNotesGenerator.INSTANCE.formatReleaseNotes(versionNotes, ((Number)object2).intValue());
        this.getLogger().info("-- start of release notes");
        this.getLogger().info(releaseNotes);
        this.getLogger().info("-- end of release notes");
        Object object3 = this.getTargetFiles().get();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"get(...)");
        Iterable $this$forEach$iv = (Iterable)object3;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CharSequence it = (CharSequence)element$iv;
            boolean bl3 = false;
            FilesKt.writeText$default((File)new File(((Object)it).toString()), (String)releaseNotes, null, (int)2, null);
        }
    }

    private static final void taskAction$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void taskAction$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void taskAction$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }
}

