/*
 * Decompiled with CFR 0.152.
 */
package net.hubalek.gradle.gitreleasenotes;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.hubalek.gradle.gitreleasenotes.GitValueSource;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b&\u0018\u0000 \u00062\u00020\u0001:\u0001\u0006B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002J\b\u0010\u0005\u001a\u00020\u0004H\u0016\u00a8\u0006\u0007"}, d2={"Lnet/hubalek/gradle/gitreleasenotes/LatestVersionNameValueSource;", "Lnet/hubalek/gradle/gitreleasenotes/GitValueSource;", "()V", "latestVersionName", "", "obtain", "Companion", "plugin"})
public abstract class LatestVersionNameValueSource
extends GitValueSource {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String RELEASE_BRANCH_PREFIX = "release/";

    public LatestVersionNameValueSource() {
        super("describe --abbrev=0 --tags");
    }

    @Override
    @NotNull
    public String obtain() {
        return this.latestVersionName();
    }

    private final String latestVersionName() {
        String string;
        Logger logger = LoggerFactory.getLogger(this.getClass());
        String envTag = System.getenv().get("BUILD_VERSION");
        if (envTag != null && !Intrinsics.areEqual((Object)envTag, (Object)"")) {
            logger.info("Using tag from environment variable: `{}`", (Object)envTag);
            string = envTag;
        } else {
            String currentBranch = this.callGit("rev-parse --abbrev-ref HEAD");
            if (StringsKt.startsWith$default((String)currentBranch, (String)RELEASE_BRANCH_PREFIX, (boolean)false, (int)2, null)) {
                String string2 = currentBranch.substring(8);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            } else {
                string = this.callGit("describe --abbrev=0 --tags");
            }
        }
        return string;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lnet/hubalek/gradle/gitreleasenotes/LatestVersionNameValueSource$Companion;", "", "()V", "RELEASE_BRANCH_PREFIX", "", "plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

