/*
 * Decompiled with CFR 0.152.
 */
package net.hubalek.gradle.gitreleasenotes;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.hubalek.gradle.gitreleasenotes.GenerateReleaseNotesTask;
import net.hubalek.gradle.gitreleasenotes.GitReleaseNotesConfigurationExtension;
import net.hubalek.gradle.gitreleasenotes.ReleaseNotesGenerator;
import org.gradle.api.DefaultTask;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\b&\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\b\u0010\n\u001a\u00020\u0004H\u0002J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\b\u0010\f\u001a\u00020\rH\u0007J\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u0004*\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u0010"}, d2={"Lnet/hubalek/gradle/gitreleasenotes/GenerateReleaseNotesTask;", "Lorg/gradle/api/DefaultTask;", "()V", "callGit", "", "command", "workingDir", "Ljava/io/File;", "getCommentsLog", "getTagsLog", "gitCommand", "latestVersionName", "taskAction", "", "runCommand", "Companion", "plugin"})
@SourceDebugExtension(value={"SMAP\nGenerateReleaseNotesTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GenerateReleaseNotesTask.kt\nnet/hubalek/gradle/gitreleasenotes/GenerateReleaseNotesTask\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,127:1\n1#2:128\n1549#3:129\n1620#3,3:130\n1855#3,2:133\n1855#3,2:135\n37#4,2:137\n*S KotlinDebug\n*F\n+ 1 GenerateReleaseNotesTask.kt\nnet/hubalek/gradle/gitreleasenotes/GenerateReleaseNotesTask\n*L\n31#1:129\n31#1:130,3\n51#1:133,2\n98#1:135,2\n111#1:137,2\n*E\n"})
public abstract class GenerateReleaseNotesTask
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String RELEASE_BRANCH_PREFIX = "release/";

    /*
     * WARNING - void declaration
     */
    @TaskAction
    public final void taskAction() {
        void $this$mapTo$iv$iv;
        File file;
        GitReleaseNotesConfigurationExtension gitReleaseNotesConfigurationExtension = (GitReleaseNotesConfigurationExtension)this.getExtensions().findByType(GitReleaseNotesConfigurationExtension.class);
        if (gitReleaseNotesConfigurationExtension == null && (gitReleaseNotesConfigurationExtension = (GitReleaseNotesConfigurationExtension)this.getProject().getExtensions().findByType(GitReleaseNotesConfigurationExtension.class)) == null) {
            throw new IllegalStateException("Extension not found");
        }
        GitReleaseNotesConfigurationExtension gitReleaseNotesConfigurationExtension2 = gitReleaseNotesConfigurationExtension;
        ListProperty<CharSequence> targetFiles = gitReleaseNotesConfigurationExtension2.getTargetFiles();
        String string = (String)gitReleaseNotesConfigurationExtension2.getWorkingDir().get();
        if (string != null) {
            String it = string;
            boolean bl = false;
            file = new File(it);
        } else {
            file = this.getProject().getProjectDir();
        }
        File workingDir = file;
        Intrinsics.checkNotNull((Object)workingDir);
        String gitVersionName = ((Object)StringsKt.trim((CharSequence)this.latestVersionName(workingDir))).toString();
        System.out.println((Object)("\nCreating release notes for version `" + gitVersionName + '`'));
        StringBuilder stringBuilder = new StringBuilder().append("Storing to following files:\n");
        Object object = targetFiles.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        System.out.println((Object)stringBuilder.append(CollectionsKt.joinToString$default((Iterable)((Iterable)object), (CharSequence)"\n", null, null, (int)0, null, (Function1)taskAction.1.INSTANCE, (int)30, null)).append('\n').toString());
        String[] stringArray = new String[]{"."};
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)gitVersionName, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map = false;
        Iterable bl = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(((Object)StringsKt.trim((CharSequence)((CharSequence)it))).toString());
        }
        List parts = (List)destination$iv$iv;
        int major = Integer.parseInt((String)parts.get(0));
        int minor = Integer.parseInt((String)parts.get(1));
        int patch = Integer.parseInt((String)parts.get(2));
        boolean bl3 = 0 <= patch ? patch < 100 : (destination$iv$iv = false);
        if (_Assertions.ENABLED && !destination$iv$iv) {
            String $i$f$mapTo2 = "Assertion failed";
            throw new AssertionError((Object)$i$f$mapTo2);
        }
        boolean bl4 = 0 <= minor ? minor < 100 : (destination$iv$iv = false);
        if (_Assertions.ENABLED && !destination$iv$iv) {
            String $i$f$mapTo2 = "Assertion failed";
            throw new AssertionError((Object)$i$f$mapTo2);
        }
        ReleaseNotesGenerator.VersionNotes versionNotes = ReleaseNotesGenerator.INSTANCE.generateReleaseNotes(gitVersionName, this.getTagsLog(workingDir), this.getCommentsLog(workingDir));
        Object object2 = gitReleaseNotesConfigurationExtension2.getMaxTextLength().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        String releaseNotes = ReleaseNotesGenerator.INSTANCE.formatReleaseNotes(versionNotes, ((Number)object2).intValue());
        System.out.println((Object)"-- start of release notes");
        System.out.println((Object)releaseNotes);
        System.out.println((Object)"-- end of release notes");
        Object object3 = targetFiles.get();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"get(...)");
        Iterable $this$forEach$iv = (Iterable)object3;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CharSequence it = (CharSequence)element$iv;
            boolean bl5 = false;
            FilesKt.writeText$default((File)new File(((Object)it).toString()), (String)releaseNotes, null, (int)2, null);
        }
    }

    private final String getCommentsLog(File workingDir) {
        return this.callGit("log --pretty=%H:%s", workingDir);
    }

    private final String getTagsLog(File workingDir) {
        return this.callGit("log --no-walk --tags --pretty=%H:%d --decorate=full", workingDir);
    }

    private final String latestVersionName(File workingDir) {
        String string;
        String envTag = System.getenv().get("BUILD_VERSION");
        if (envTag != null && !Intrinsics.areEqual((Object)envTag, (Object)"")) {
            this.getLogger().debug("Using tag from environment variable: `{}`", (Object)envTag);
            string = envTag;
        } else {
            String currentBranch = this.callGit("rev-parse --abbrev-ref HEAD", workingDir);
            if (StringsKt.startsWith$default((String)currentBranch, (String)RELEASE_BRANCH_PREFIX, (boolean)false, (int)2, null)) {
                String string2 = currentBranch.substring(8);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            } else {
                string = this.callGit("describe --abbrev=0 --tags", workingDir);
            }
        }
        return string;
    }

    private final String callGit(String command, File workingDir) {
        this.getLogger().debug("Command is `" + this.gitCommand() + ' ' + command + "`, working dir is `" + workingDir.getAbsolutePath() + '`');
        String string = this.runCommand(this.gitCommand() + ' ' + command, workingDir);
        if (string == null) {
            throw new UnsupportedOperationException("Unable to invoke GIT");
        }
        return string;
    }

    private final String gitCommand() {
        Object[] objectArray = new String[]{"/usr/bin/git", "/usr/local/bin/git"};
        List possibleGitLocations = CollectionsKt.listOf((Object[])objectArray);
        Iterable $this$forEach$iv = possibleGitLocations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String gitBinFilePath = (String)element$iv;
            boolean bl = false;
            if (!new File(gitBinFilePath).exists()) continue;
            this.getLogger().debug("Returning git bin {}", (Object)gitBinFilePath);
            return gitBinFilePath;
        }
        throw new UnsupportedOperationException("Unable to find git command");
    }

    private final String runCommand(String $this$runCommand, File workingDir) {
        String string;
        try {
            CharSequence charSequence = $this$runCommand;
            Object object = new Regex("\\s");
            int n = 0;
            List parts = object.split(charSequence, n);
            this.getLogger().debug("parts=" + CollectionsKt.joinToString$default((Iterable)parts, null, null, null, (int)0, null, (Function1)runCommand.1.INSTANCE, (int)31, null));
            Collection $this$toTypedArray$iv = parts;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            object = thisCollection$iv.toArray(new String[0]);
            Process process = new ProcessBuilder(Arrays.copyOf(object, ((String[])object).length)).directory(workingDir).redirectOutput(ProcessBuilder.Redirect.PIPE).redirectError(ProcessBuilder.Redirect.PIPE).start();
            process.waitFor(60L, TimeUnit.MINUTES);
            InputStream inputStream = process.getInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
            object = inputStream;
            Charset charset = Charsets.UTF_8;
            Reader reader = new InputStreamReader((InputStream)object, charset);
            int n2 = 8192;
            string = TextStreamsKt.readText((Reader)(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n2)));
        }
        catch (IOException e) {
            this.getLogger().error("Error executing git", (Throwable)e);
            string = null;
        }
        return string;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lnet/hubalek/gradle/gitreleasenotes/GenerateReleaseNotesTask$Companion;", "", "()V", "RELEASE_BRANCH_PREFIX", "", "plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

