/*
 * Decompiled with CFR 0.152.
 */
package net.hubalek.gradle.gitreleasenotes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0005\u001f !\"#B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0002J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\u0004H\u0002J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\r\u001a\u00020\u0004H\u0002J\u001c\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0004H\u0002J\u0010\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0004H\u0002J\u0016\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u001e\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0004J@\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\t2\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u00042\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lnet/hubalek/gradle/gitreleasenotes/ReleaseNotesGenerator;", "", "()V", "COMMENTS_DELIMITER", "", "debugLog", "", "msg", "extractCommentsList", "", "Lnet/hubalek/gradle/gitreleasenotes/ReleaseNotesGenerator$CommentInfo;", "commentsLog", "extractTag", "rawTagInfo", "extractTagsMap", "", "Lnet/hubalek/gradle/gitreleasenotes/ReleaseNotesGenerator$TagInfo;", "tagsLog", "extractVersionPrefix", "currentVersion", "formatReleaseNotes", "data", "Lnet/hubalek/gradle/gitreleasenotes/ReleaseNotesGenerator$VersionNotes;", "maxLength", "", "generateReleaseNotes", "mergeTagsAndComments", "Lnet/hubalek/gradle/gitreleasenotes/ReleaseNotesGenerator$VersionNote;", "versionPrefix", "tags", "comments", "CommentInfo", "NoteType", "TagInfo", "VersionNote", "VersionNotes", "git-release-notes-plugin"})
public final class ReleaseNotesGenerator {
    @NotNull
    public static final ReleaseNotesGenerator INSTANCE = new ReleaseNotesGenerator();
    @NotNull
    public static final String COMMENTS_DELIMITER = ":";

    private ReleaseNotesGenerator() {
    }

    @NotNull
    public final VersionNotes generateReleaseNotes(@NotNull String currentVersion, @NotNull String tagsLog, @NotNull String commentsLog) {
        Intrinsics.checkNotNullParameter((Object)currentVersion, (String)"currentVersion");
        Intrinsics.checkNotNullParameter((Object)tagsLog, (String)"tagsLog");
        Intrinsics.checkNotNullParameter((Object)commentsLog, (String)"commentsLog");
        this.debugLog(Intrinsics.stringPlus((String)"Comments log: ", (Object)commentsLog));
        this.debugLog(Intrinsics.stringPlus((String)"Tags log: ", (Object)tagsLog));
        String versionPrefix = this.extractVersionPrefix(currentVersion);
        Map<String, TagInfo> tags = this.extractTagsMap(tagsLog);
        List<CommentInfo> comments = this.extractCommentsList(commentsLog);
        this.debugLog("List of comments and tags: ");
        this.debugLog("--------------------------");
        List<VersionNote> versionNotes = this.mergeTagsAndComments(currentVersion, versionPrefix, tags, comments);
        this.debugLog("--------------------------");
        return new VersionNotes(Intrinsics.stringPlus((String)versionPrefix, (Object)"x"), CollectionsKt.reversed((Iterable)versionNotes));
    }

    private final void debugLog(String msg) {
        Logger.getLogger(ReleaseNotesGenerator.class.getSimpleName()).log(Level.FINE, msg);
    }

    private final String extractVersionPrefix(String currentVersion) {
        String string = currentVersion;
        int n = 0;
        int n2 = StringsKt.lastIndexOf$default((CharSequence)currentVersion, (String)".", (int)0, (boolean)false, (int)6, null) + 1;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        return string3;
    }

    /*
     * WARNING - void declaration
     */
    private final List<VersionNote> mergeTagsAndComments(String currentVersion, String versionPrefix, Map<String, TagInfo> tags, List<CommentInfo> comments) {
        void $this$mapNotNullTo$iv$iv;
        TagInfo latestTagInfo = null;
        Iterable $this$mapNotNull$iv = comments;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            VersionNote versionNote;
            TagInfo tagInfo;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            CommentInfo it = (CommentInfo)element$iv$iv;
            boolean bl2 = false;
            TagInfo currentTagInfo = tags.get(it.getCommitHash());
            if (currentTagInfo != null) {
                latestTagInfo = currentTagInfo;
            }
            String latestTag = (tagInfo = latestTagInfo) == null ? null : tagInfo.getTag();
            INSTANCE.debugLog('[' + it.getCommitHash() + "]:[" + latestTag + "] -  " + it.getComment());
            String string = it.getComment();
            int n = StringsKt.indexOf$default((CharSequence)it.getComment(), (String)"]", (int)0, (boolean)false, (int)6, null) + 1;
            boolean bl3 = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            string = string3;
            n = 0;
            String string4 = string;
            if (string4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            String commentText = ((Object)StringsKt.trim((CharSequence)string4)).toString();
            if ((latestTag != null ? (StringsKt.startsWith$default((String)latestTag, (String)versionPrefix, (boolean)false, (int)2, null) && StringsKt.startsWith$default((String)it.getComment(), (String)"[", (boolean)false, (int)2, null) ? new VersionNote(latestTag, NoteType.FEATURE, commentText) : (VersionNote)null) : (StringsKt.startsWith$default((String)it.getComment(), (String)"[", (boolean)false, (int)2, null) ? new VersionNote(currentVersion, NoteType.FEATURE, commentText) : (VersionNote)null)) == null) continue;
            versionNote = versionNote;
            boolean bl4 = false;
            boolean bl5 = false;
            VersionNote it$iv$iv = versionNote;
            boolean bl6 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.reversed((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private final List<CommentInfo> extractCommentsList(String commentsLog) {
        void $this$mapNotNullTo$iv$iv;
        String[] stringArray = new String[]{"\n"};
        Iterable $this$mapNotNull$iv = StringsKt.split$default((CharSequence)commentsLog, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            CommentInfo commentInfo;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String singleComment = (String)element$iv$iv;
            boolean bl2 = false;
            int indexOfDelimiter = StringsKt.indexOf$default((CharSequence)singleComment, (String)COMMENTS_DELIMITER, (int)0, (boolean)false, (int)6, null);
            if (indexOfDelimiter >= 0) {
                String string = singleComment;
                int n = 0;
                int n2 = 0;
                String string2 = string;
                if (string2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.substring(n, indexOfDelimiter);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                string = singleComment;
                n = indexOfDelimiter + COMMENTS_DELIMITER.length();
                n2 = singleComment.length();
                boolean bl3 = false;
                String string4 = string;
                if (string4 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string5 = string4.substring(n, n2);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                commentInfo = new CommentInfo(string3, string5);
            } else {
                commentInfo = null;
            }
            if (commentInfo == null) continue;
            CommentInfo commentInfo2 = commentInfo;
            boolean bl4 = false;
            boolean bl5 = false;
            CommentInfo it$iv$iv = commentInfo2;
            boolean bl6 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, TagInfo> extractTagsMap(String tagsLog) {
        void $this$mapTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        String[] stringArray = new String[]{"\n"};
        Iterable $this$mapNotNull$iv = StringsKt.split$default((CharSequence)tagsLog, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Object object = $this$forEach$iv$iv$iv.iterator();
        while (object.hasNext()) {
            TagInfo tagInfo;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = object.next();
            boolean bl = false;
            String singleTagLog = (String)element$iv$iv;
            boolean bl2 = false;
            int indexOfDelimiter = StringsKt.indexOf$default((CharSequence)singleTagLog, (String)COMMENTS_DELIMITER, (int)0, (boolean)false, (int)6, null);
            if (indexOfDelimiter >= 0) {
                String string = singleTagLog;
                int n = indexOfDelimiter + COMMENTS_DELIMITER.length();
                int n2 = 0;
                String string2 = string;
                if (string2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.substring(n);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
                String rawTagInfo = INSTANCE.extractTag(string3);
                if (rawTagInfo != null) {
                    String commitHash;
                    String string4 = singleTagLog;
                    n2 = 0;
                    boolean bl3 = false;
                    String string5 = string4;
                    if (string5 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)string5.substring(n2, indexOfDelimiter), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    tagInfo = new TagInfo(commitHash, rawTagInfo);
                } else {
                    tagInfo = null;
                }
            } else {
                tagInfo = null;
            }
            if (tagInfo == null) continue;
            TagInfo tagInfo2 = tagInfo;
            boolean bl4 = false;
            boolean bl5 = false;
            TagInfo it$iv$iv = tagInfo2;
            boolean bl6 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$mapNotNullTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            object = (TagInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it.getCommitHash(), (Object)it);
            collection.add(pair);
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    @NotNull
    public final String formatReleaseNotes(@NotNull VersionNotes data, int maxLength) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        String header = "Release notes for version " + data.getVersion() + "\n--------------------------------";
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(header);
        boolean bl = false;
        Set alreadyReportedComments = new LinkedHashSet();
        Iterable $this$forEach$iv = data.getNotes();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VersionNote note = (VersionNote)element$iv;
            boolean bl2 = false;
            String noteText = "\n- " + note.getText() + " (version " + note.getVersion() + ')';
            if (stringBuilder.length() + noteText.length() >= maxLength || alreadyReportedComments.contains(note.getText())) continue;
            stringBuilder.append(noteText);
            Collection collection = alreadyReportedComments;
            String string = note.getText();
            boolean bl3 = false;
            collection.add(string);
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"stringBuilder.toString()");
        return string;
    }

    private final String extractTag(String rawTagInfo) {
        String string;
        String string2 = "refs/tags/([0-9]+)\\.([0-9]+)\\.([0-9]+)";
        boolean bl = false;
        Regex regex = new Regex(string2);
        MatchResult split = Regex.find$default((Regex)regex, (CharSequence)rawTagInfo, (int)0, (int)2, null);
        if (split != null) {
            List groups = split.getGroupValues();
            string = (String)groups.get(1) + '.' + (String)groups.get(2) + '.' + (String)groups.get(3);
        } else {
            string = null;
        }
        return string;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lnet/hubalek/gradle/gitreleasenotes/ReleaseNotesGenerator$CommentInfo;", "", "commitHash", "", "comment", "(Ljava/lang/String;Ljava/lang/String;)V", "getComment", "()Ljava/lang/String;", "getCommitHash", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "git-release-notes-plugin"})
    private static final class CommentInfo {
        @NotNull
        private final String commitHash;
        @NotNull
        private final String comment;

        public CommentInfo(@NotNull String commitHash, @NotNull String comment) {
            Intrinsics.checkNotNullParameter((Object)commitHash, (String)"commitHash");
            Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
            this.commitHash = commitHash;
            this.comment = comment;
        }

        @NotNull
        public final String getCommitHash() {
            return this.commitHash;
        }

        @NotNull
        public final String getComment() {
            return this.comment;
        }

        @NotNull
        public final String component1() {
            return this.commitHash;
        }

        @NotNull
        public final String component2() {
            return this.comment;
        }

        @NotNull
        public final CommentInfo copy(@NotNull String commitHash, @NotNull String comment) {
            Intrinsics.checkNotNullParameter((Object)commitHash, (String)"commitHash");
            Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
            return new CommentInfo(commitHash, comment);
        }

        public static /* synthetic */ CommentInfo copy$default(CommentInfo commentInfo, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = commentInfo.commitHash;
            }
            if ((n & 2) != 0) {
                string2 = commentInfo.comment;
            }
            return commentInfo.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "CommentInfo(commitHash=" + this.commitHash + ", comment=" + this.comment + ')';
        }

        public int hashCode() {
            int result = this.commitHash.hashCode();
            result = result * 31 + this.comment.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CommentInfo)) {
                return false;
            }
            CommentInfo commentInfo = (CommentInfo)other;
            if (!Intrinsics.areEqual((Object)this.commitHash, (Object)commentInfo.commitHash)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.comment, (Object)commentInfo.comment);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lnet/hubalek/gradle/gitreleasenotes/ReleaseNotesGenerator$TagInfo;", "", "commitHash", "", "tag", "(Ljava/lang/String;Ljava/lang/String;)V", "getCommitHash", "()Ljava/lang/String;", "getTag", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "git-release-notes-plugin"})
    private static final class TagInfo {
        @NotNull
        private final String commitHash;
        @NotNull
        private final String tag;

        public TagInfo(@NotNull String commitHash, @NotNull String tag) {
            Intrinsics.checkNotNullParameter((Object)commitHash, (String)"commitHash");
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            this.commitHash = commitHash;
            this.tag = tag;
        }

        @NotNull
        public final String getCommitHash() {
            return this.commitHash;
        }

        @NotNull
        public final String getTag() {
            return this.tag;
        }

        @NotNull
        public final String component1() {
            return this.commitHash;
        }

        @NotNull
        public final String component2() {
            return this.tag;
        }

        @NotNull
        public final TagInfo copy(@NotNull String commitHash, @NotNull String tag) {
            Intrinsics.checkNotNullParameter((Object)commitHash, (String)"commitHash");
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            return new TagInfo(commitHash, tag);
        }

        public static /* synthetic */ TagInfo copy$default(TagInfo tagInfo, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = tagInfo.commitHash;
            }
            if ((n & 2) != 0) {
                string2 = tagInfo.tag;
            }
            return tagInfo.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "TagInfo(commitHash=" + this.commitHash + ", tag=" + this.tag + ')';
        }

        public int hashCode() {
            int result = this.commitHash.hashCode();
            result = result * 31 + this.tag.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TagInfo)) {
                return false;
            }
            TagInfo tagInfo = (TagInfo)other;
            if (!Intrinsics.areEqual((Object)this.commitHash, (Object)tagInfo.commitHash)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.tag, (Object)tagInfo.tag);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lnet/hubalek/gradle/gitreleasenotes/ReleaseNotesGenerator$NoteType;", "", "(Ljava/lang/String;I)V", "FEATURE", "BUGFIX", "git-release-notes-plugin"})
    public static final class NoteType
    extends Enum<NoteType> {
        public static final /* enum */ NoteType FEATURE = new NoteType();
        public static final /* enum */ NoteType BUGFIX = new NoteType();
        private static final /* synthetic */ NoteType[] $VALUES;

        public static NoteType[] values() {
            return (NoteType[])$VALUES.clone();
        }

        public static NoteType valueOf(String value) {
            return Enum.valueOf(NoteType.class, value);
        }

        static {
            $VALUES = noteTypeArray = new NoteType[]{NoteType.FEATURE, NoteType.BUGFIX};
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lnet/hubalek/gradle/gitreleasenotes/ReleaseNotesGenerator$VersionNote;", "", "version", "", "noteType", "Lnet/hubalek/gradle/gitreleasenotes/ReleaseNotesGenerator$NoteType;", "text", "(Ljava/lang/String;Lnet/hubalek/gradle/gitreleasenotes/ReleaseNotesGenerator$NoteType;Ljava/lang/String;)V", "getNoteType", "()Lnet/hubalek/gradle/gitreleasenotes/ReleaseNotesGenerator$NoteType;", "getText", "()Ljava/lang/String;", "getVersion", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "git-release-notes-plugin"})
    public static final class VersionNote {
        @NotNull
        private final String version;
        @NotNull
        private final NoteType noteType;
        @NotNull
        private final String text;

        public VersionNote(@NotNull String version, @NotNull NoteType noteType, @NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            Intrinsics.checkNotNullParameter((Object)((Object)noteType), (String)"noteType");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            this.version = version;
            this.noteType = noteType;
            this.text = text;
        }

        @NotNull
        public final String getVersion() {
            return this.version;
        }

        @NotNull
        public final NoteType getNoteType() {
            return this.noteType;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        @NotNull
        public final String component1() {
            return this.version;
        }

        @NotNull
        public final NoteType component2() {
            return this.noteType;
        }

        @NotNull
        public final String component3() {
            return this.text;
        }

        @NotNull
        public final VersionNote copy(@NotNull String version, @NotNull NoteType noteType, @NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            Intrinsics.checkNotNullParameter((Object)((Object)noteType), (String)"noteType");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            return new VersionNote(version, noteType, text);
        }

        public static /* synthetic */ VersionNote copy$default(VersionNote versionNote, String string, NoteType noteType, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = versionNote.version;
            }
            if ((n & 2) != 0) {
                noteType = versionNote.noteType;
            }
            if ((n & 4) != 0) {
                string2 = versionNote.text;
            }
            return versionNote.copy(string, noteType, string2);
        }

        @NotNull
        public String toString() {
            return "VersionNote(version=" + this.version + ", noteType=" + (Object)((Object)this.noteType) + ", text=" + this.text + ')';
        }

        public int hashCode() {
            int result = this.version.hashCode();
            result = result * 31 + this.noteType.hashCode();
            result = result * 31 + this.text.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof VersionNote)) {
                return false;
            }
            VersionNote versionNote = (VersionNote)other;
            if (!Intrinsics.areEqual((Object)this.version, (Object)versionNote.version)) {
                return false;
            }
            if (this.noteType != versionNote.noteType) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.text, (Object)versionNote.text);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lnet/hubalek/gradle/gitreleasenotes/ReleaseNotesGenerator$VersionNotes;", "", "version", "", "notes", "", "Lnet/hubalek/gradle/gitreleasenotes/ReleaseNotesGenerator$VersionNote;", "(Ljava/lang/String;Ljava/util/List;)V", "getNotes", "()Ljava/util/List;", "getVersion", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "git-release-notes-plugin"})
    public static final class VersionNotes {
        @NotNull
        private final String version;
        @NotNull
        private final List<VersionNote> notes;

        public VersionNotes(@NotNull String version, @NotNull List<VersionNote> notes) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            Intrinsics.checkNotNullParameter(notes, (String)"notes");
            this.version = version;
            this.notes = notes;
        }

        @NotNull
        public final String getVersion() {
            return this.version;
        }

        @NotNull
        public final List<VersionNote> getNotes() {
            return this.notes;
        }

        @NotNull
        public final String component1() {
            return this.version;
        }

        @NotNull
        public final List<VersionNote> component2() {
            return this.notes;
        }

        @NotNull
        public final VersionNotes copy(@NotNull String version, @NotNull List<VersionNote> notes) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            Intrinsics.checkNotNullParameter(notes, (String)"notes");
            return new VersionNotes(version, notes);
        }

        public static /* synthetic */ VersionNotes copy$default(VersionNotes versionNotes, String string, List list, int n, Object object) {
            if ((n & 1) != 0) {
                string = versionNotes.version;
            }
            if ((n & 2) != 0) {
                list = versionNotes.notes;
            }
            return versionNotes.copy(string, list);
        }

        @NotNull
        public String toString() {
            return "VersionNotes(version=" + this.version + ", notes=" + this.notes + ')';
        }

        public int hashCode() {
            int result = this.version.hashCode();
            result = result * 31 + ((Object)this.notes).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof VersionNotes)) {
                return false;
            }
            VersionNotes versionNotes = (VersionNotes)other;
            if (!Intrinsics.areEqual((Object)this.version, (Object)versionNotes.version)) {
                return false;
            }
            return Intrinsics.areEqual(this.notes, versionNotes.notes);
        }
    }
}

