/*
 * Decompiled with CFR 0.152.
 */
package net.hubalek.gradle.gitreleasenotes;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.hubalek.gradle.gitreleasenotes.GenerateReleaseNotesTask;
import net.hubalek.gradle.gitreleasenotes.GitReleaseNotesConfigurationExtension;
import net.hubalek.gradle.gitreleasenotes.ReleaseNotesGenerator;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002J\b\u0010\u0006\u001a\u00020\u0004H\u0002J\b\u0010\u0007\u001a\u00020\u0004H\u0002J\b\u0010\b\u001a\u00020\u0004H\u0002J\b\u0010\t\u001a\u00020\u0004H\u0002J\b\u0010\n\u001a\u00020\u000bH\u0007J\u0016\u0010\f\u001a\u0004\u0018\u00010\u0004*\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u0010"}, d2={"Lnet/hubalek/gradle/gitreleasenotes/GenerateReleaseNotesTask;", "Lorg/gradle/api/DefaultTask;", "()V", "callGit", "", "command", "getCommentsLog", "getTagsLog", "gitCommand", "latestVersionName", "taskAction", "", "runCommand", "workingDir", "Ljava/io/File;", "Companion", "git-release-notes-plugin"})
public class GenerateReleaseNotesTask
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String RELEASE_BRANCH_PREFIX = "release/";

    /*
     * WARNING - void declaration
     */
    @TaskAction
    public final void taskAction() {
        void $this$mapTo$iv$iv222;
        Object object = this.getProject().getExtensions().getByName("gitReleaseNotes");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type net.hubalek.gradle.gitreleasenotes.GitReleaseNotesConfigurationExtension");
        }
        List<CharSequence> targetFiles = ((GitReleaseNotesConfigurationExtension)object).getTargetFiles();
        String string = this.latestVersionName();
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String gitVersionName = ((Object)StringsKt.trim((CharSequence)string2)).toString();
        string = "\nCreating release notes for version `" + gitVersionName + '`';
        bl = false;
        System.out.println((Object)string);
        string = "Storing to following files:\n" + CollectionsKt.joinToString$default((Iterable)targetFiles, (CharSequence)"\n", null, null, (int)0, null, (Function1)taskAction.1.INSTANCE, (int)30, null) + '\n';
        bl = false;
        System.out.println((Object)string);
        String[] stringArray = new String[]{"."};
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)gitVersionName, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv4222 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo4222 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv222) {
            void it;
            String string3 = (String)item$iv$iv;
            Collection collection = destination$iv$iv4222;
            boolean bl2 = false;
            void var13_33 = it;
            boolean bl3 = false;
            void v1 = var13_33;
            if (v1 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            String string4 = ((Object)StringsKt.trim((CharSequence)((CharSequence)v1))).toString();
            collection.add(string4);
        }
        List parts = (List)destination$iv$iv4222;
        String $i$f$map22 = (String)parts.get(0);
        boolean $this$mapTo$iv$iv222 = false;
        int major = Integer.parseInt($i$f$map22);
        String $this$mapTo$iv$iv222 = (String)parts.get(1);
        boolean destination$iv$iv4222 = false;
        int minor = Integer.parseInt($this$mapTo$iv$iv222);
        String destination$iv$iv4222 = (String)parts.get(2);
        $i$f$mapTo4222 = false;
        int patch = Integer.parseInt(destination$iv$iv4222);
        boolean destination$iv$iv4222 = 0 <= patch ? patch <= 99 : false;
        $i$f$mapTo4222 = false;
        boolean bl4 = false;
        if (_Assertions.ENABLED && !destination$iv$iv4222) {
            boolean bl5 = false;
            String string5 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string5));
        }
        destination$iv$iv4222 = 0 <= minor ? minor <= 99 : false;
        $i$f$mapTo4222 = false;
        bl4 = false;
        if (_Assertions.ENABLED && !destination$iv$iv4222) {
            boolean bl6 = false;
            String string6 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string6));
        }
        String releaseNotes = ReleaseNotesGenerator.INSTANCE.formatReleaseNotes(ReleaseNotesGenerator.INSTANCE.generateReleaseNotes(gitVersionName, this.getTagsLog(), this.getCommentsLog()));
        String $i$f$mapTo4222 = "-- start of release notes";
        bl4 = false;
        System.out.println((Object)$i$f$mapTo4222);
        boolean $i$f$mapTo4222 = false;
        System.out.println((Object)releaseNotes);
        String $i$f$mapTo4222 = "-- end of release notes";
        bl4 = false;
        System.out.println((Object)$i$f$mapTo4222);
        Iterable $this$forEach$iv = targetFiles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CharSequence it = (CharSequence)element$iv;
            boolean bl7 = false;
            FilesKt.writeText$default((File)new File(((Object)it).toString()), (String)releaseNotes, null, (int)2, null);
        }
    }

    private final String getCommentsLog() {
        return this.callGit("log --pretty=%H:%s");
    }

    private final String getTagsLog() {
        return this.callGit("log --no-walk --tags --pretty=%H:%d --decorate=full");
    }

    private final String latestVersionName() {
        String string;
        String envTag = System.getenv().get("BUILD_VERSION");
        if (envTag != null && !Intrinsics.areEqual((Object)envTag, (Object)"")) {
            this.getLogger().debug("Using tag from environment variable: `{}`", (Object)envTag);
            string = envTag;
        } else {
            String currentBranch = this.callGit("rev-parse --abbrev-ref HEAD");
            if (StringsKt.startsWith$default((String)currentBranch, (String)RELEASE_BRANCH_PREFIX, (boolean)false, (int)2, null)) {
                String string2 = currentBranch;
                int n = RELEASE_BRANCH_PREFIX.length();
                boolean bl = false;
                String string3 = string2;
                if (string3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string4 = string3.substring(n);
                string = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
            } else {
                string = this.callGit("describe --abbrev=0");
            }
        }
        return string;
    }

    private final String callGit(String command) {
        File workingDir = this.getProject().getRootDir();
        this.getLogger().debug("Command is `" + this.gitCommand() + ' ' + command + "`, working dir is `" + workingDir.getAbsolutePath() + '`');
        String string = this.gitCommand() + ' ' + command;
        Intrinsics.checkNotNullExpressionValue((Object)workingDir, (String)"workingDir");
        String string2 = this.runCommand(string, workingDir);
        if (string2 == null) {
            throw new UnsupportedOperationException("Unable to invoke GIT");
        }
        return string2;
    }

    private final String gitCommand() {
        Object[] objectArray = new String[]{"/usr/bin/git", "/usr/local/bin/git"};
        List possibleGitLocations = CollectionsKt.listOf((Object[])objectArray);
        Iterable $this$forEach$iv = possibleGitLocations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String gitBinFilePath = (String)element$iv;
            boolean bl = false;
            if (!new File(gitBinFilePath).exists()) continue;
            this.getLogger().debug("Returning git bin {}", (Object)gitBinFilePath);
            return gitBinFilePath;
        }
        throw new UnsupportedOperationException("Unable to find git command");
    }

    private final String runCommand(String $this$runCommand, File workingDir) {
        String string;
        try {
            CharSequence charSequence = $this$runCommand;
            Object object = "\\s";
            int n = 0;
            object = new Regex((String)object);
            n = 0;
            boolean bl = false;
            List parts = object.split(charSequence, n);
            this.getLogger().debug(Intrinsics.stringPlus((String)"parts=", (Object)CollectionsKt.joinToString$default((Iterable)parts, null, null, null, (int)0, null, (Function1)runCommand.1.INSTANCE, (int)31, null)));
            Collection $this$toTypedArray$iv = parts;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            object = stringArray;
            Process process = new ProcessBuilder(Arrays.copyOf(object, ((String[])object).length)).directory(workingDir).redirectOutput(ProcessBuilder.Redirect.PIPE).redirectError(ProcessBuilder.Redirect.PIPE).start();
            process.waitFor(60L, TimeUnit.MINUTES);
            object = process.getInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"process.inputStream");
            Charset charset = Charsets.UTF_8;
            bl = false;
            Object object2 = object;
            int n2 = 0;
            object2 = new InputStreamReader((InputStream)object2, charset);
            n2 = 8192;
            boolean bl2 = false;
            string = TextStreamsKt.readText((Reader)(object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n2)));
        }
        catch (IOException e) {
            this.getLogger().error("Error executing git", (Throwable)e);
            string = null;
        }
        return string;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lnet/hubalek/gradle/gitreleasenotes/GenerateReleaseNotesTask$Companion;", "", "()V", "RELEASE_BRANCH_PREFIX", "", "git-release-notes-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

