package com.zeugmasolutions.localehelper

import android.content.Context
import android.content.res.Configuration
import android.util.Log

fun Configuration.toDebugString(): String {
    return "Configuration[" + this.locales.toLanguageTags() + ",uiMode=" + this.uiMode.toDebugString() + "]"
}

private fun Int.toDebugString(): String {
    return when (this and Configuration.UI_MODE_NIGHT_MASK) {
        Configuration.UI_MODE_NIGHT_NO -> "Day"
        Configuration.UI_MODE_NIGHT_YES -> "Night"
        else -> {
            "Unknown"
        }
    }
}


fun Context.toDebugString(): String {
    return "[Context: " + this.resources.configuration.toDebugString() + "]"
}

const val debuggingIsEnabled = true

fun log(throwable: Throwable? = null, block: () -> String) {
    if (debuggingIsEnabled) {
        if (throwable != null) {
            Log.d(LOG_TAG, block(), throwable)
        } else {
            Log.d(LOG_TAG, block())
        }
    }
}
